//LidHoles.scad;

//All walls are the same height;

//Previous version was 2022_06_22;
//This version is 2022_08_29;

//Changes are: 
//1:
//The mechanical pins holding the front 
//of the switch collide with the wall;
//I need small rebates to provide 
//appropriate room for those pins;

//This module defines the holes for 
//the USB power connectors in 
//the lid of a case;

include <BATT_Dimensions.scad>

module LidHoles()
{

echo("Begin LidHoles");

//I want to echo the distance between 
//the bottom of the USBinput hole and 
//the edge of the lid;
//It should be 17mm;
//The edge of the lid is on the XY plane;
//I just need the height of the bottom 
//of the USBinput hole above that plane;
//It should be:
USBinputDist = USBinputDeltaZ - USBinputZ/2;
echo("USBinputDist = ", USBinputDist);
    
translate([USBinputDeltaX, 
    USBinputDeltaY, USBinputDeltaZ])
cube([USBinputX, USBinputY, USBinputZ], 
    center=true);

//I want to echo the distance between 
//the bottom of the USBoutput hole and 
//the edge of the lid;
//It should be between 18mm and 19mm,
//certainly not near 15mm or 22mm;
//The edge of the lid is on the XY plane;
//I just need the height of the bottom 
//of the USBoutput hole above that plane;
//It should be:
USBoutputDist = USBoutputDeltaZ - USBoutputZ/2;
echo("USBoutputDist = ", USBoutputDist);
    
translate([USBoutputDeltaX, 
    USBoutputDeltaY, USBoutputDeltaZ])
cube([USBoutputX, USBoutputY, USBoutputZ], 
    center=true);

//The OnOff hole is in two parts:
//A simple cube for the PCB;
//Another simple cube for the switch itself;

//The switch protrudes through 
//the wall of the lid;
//It does need rebates inside the lid;
//It does not need holes for mounting screws;

//The hole for the PCB;
translate([OnOffHolePcbDeltaX, 
    OnOffHolePcbDeltaY, OnOffHolePcbDeltaZ])
cube([OnOffHolePcbX, 
        OnOffHolePcbY, OnOffHolePcbZ], 
    center=true);

//The hole for the switch;
translate([OnOffHoleSwDeltaX, 
    OnOffHoleSwDeltaY, OnOffHoleSwDeltaZ])
cube([OnOffHoleSwX, 
        OnOffHoleSwY, OnOffHoleSwZ], 
    center=true);

//The left rebate;
translate([OnOffHoleSwDeltaX +OnOffRebateX/2, 
    OnOffRebateDeltaY, OnOffRebateDeltaZ])
cube([OnOffRebateW, 
        OnOffRebateY, OnOffRebateZ], 
    center=true);

//The right rebate;
translate([OnOffHoleSwDeltaX -OnOffRebateX/2, 
    OnOffRebateDeltaY, OnOffRebateDeltaZ])
cube([OnOffRebateW, 
        OnOffRebateY, OnOffRebateZ], 
    center=true);

}
//
